import type { Config } from "tailwindcss"

const _defaultColors = {
  background: "hsl(var(--background))",
  border: "hsl(var(--border))",
  ring: "hsl(var(--ring))",
  input: "hsl(var(--input))",

  primary: {
    DEFAULT: "hsl(var(--primary))",
  },
  secondary: {
    DEFAULT: "hsl(var(--secondary))",
  },
  destructive: {
    DEFAULT: "hsl(var(--destructive))",
  },
  subtle: {
    DEFAULT: "hsl(var(--subtle))",
    inverted: "hsl(var(--inverted-subtle))",
  },
  muted: {
    DEFAULT: "hsl(var(--muted))",
    inverted: "hsl(var(--inverted-muted))",
  },
  accent: {
    DEFAULT: "hsl(var(--accent))",
    inverted: "hsl(var(--inverted-accent))",
  },
  strong: {
    DEFAULT: "hsl(var(--strong))",
    inverted: "hsl(var(--inverted-strong))",
  },
  popover: {
    DEFAULT: "hsl(var(--popover))",
  },
  card: {
    DEFAULT: "hsl(var(--card))",
  },
  inverted: {
    DEFAULT: "hsl(var(--inverted))",
  },
} as const

const _foregroundColors = {
  foreground: "hsl(var(--foreground))",
  primary: {
    foreground: "hsl(var(--primary-foreground))",
  },
  secondary: {
    foreground: "hsl(var(--secondary-foreground))",
  },
  destructive: {
    foreground: "hsl(var(--destructive-foreground))",
  },
  subtle: {
    foreground: "hsl(var(--subtle-foreground))",
    "inverted-foreground": "hsl(var(--inverted-subtle-foreground))",
  },
  muted: {
    foreground: "hsl(var(--muted-foreground))",
    "inverted-foreground": "hsl(var(--inverted-muted-foreground))",
  },
  accent: {
    foreground: "hsl(var(--accent-foreground))",
    "inverted-foreground": "hsl(var(--inverted-accent-foreground))",
  },
  strong: {
    foreground: "hsl(var(--strong-foreground))",
    "inverted-foreground": "hsl(var(--inverted-strong-foreground))",
  },
  popover: {
    foreground: "hsl(var(--popover-foreground))",
  },
  card: {
    foreground: "hsl(var(--card-foreground))",
  },
  inverted: {
    foreground: "hsl(var(--inverted-foreground))",
  },
} as const

export default {
  darkMode: ["class"],
  prefix: "",
  content: ["./index.html", "./src/**/*.{js,ts,jsx,tsx}"],
  theme: {
    container: {
      center: true,
      padding: "2rem",
      screens: {
        "2xl": "1400px",
      },
    },
    extend: {
      textColor: _foregroundColors,
      fill: _foregroundColors,
      borderColor: _defaultColors,
      ringColor: _defaultColors,
      stroke: {
        primary: _defaultColors.primary,
        border: _defaultColors.border,
        background: _defaultColors.background,
        "route-foreground-1": "hsl(var(--route-foreground-1))",
        "route-foreground-2": "hsl(var(--route-foreground-2))",
        "route-foreground-3": "hsl(var(--route-foreground-3))",
        "route-foreground-4": "hsl(var(--route-foreground-4))",
      },
      gradientColorStops: _defaultColors,
      boxShadowColor: {
        input: _defaultColors.input,
        primary: _defaultColors.primary,
        muted: _defaultColors.muted,
        card: _defaultColors.card,
      },
      backgroundColor: _defaultColors,
      borderRadius: {
        lg: "var(--radius)",
        md: "calc(var(--radius) - 2px)",
        sm: "calc(var(--radius) - 4px)",
      },
      keyframes: {
        "caret-blink": {
          "0%,70%,100%": { opacity: "1" },
          "20%,50%": { opacity: "0.25" },
        },
        "accordion-down": {
          from: { height: "0" },
          to: { height: "var(--radix-accordion-content-height)" },
        },
        "accordion-up": {
          from: { height: "var(--radix-accordion-content-height)" },
          to: { height: "0" },
        },
      },
      animation: {
        "caret-blink": "caret-blink 2s ease-out infinite",
        "accordion-down": "accordion-down 0.2s ease-out",
        "accordion-up": "accordion-up 0.2s ease-out",
      },
      screens: {
        'mobile-only-landscape': {
          'raw': 'only screen and (max-height: 600px) and (orientation: landscape)'
        }
      }
    },
  },
  plugins: [
    require("tailwindcss-animate"),
    // eslint-disable-next-line @typescript-eslint/no-var-requires
    require('tailwind-scrollbar')({ nocompatible: true }),
  ],
} satisfies Config
